/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.cmdhelpers;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.common.util.CmdExtendedErrorList;
import com.ibm.hsc.fsp.FSPCmdMgr;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class FspPhypSimpleCmds {
    private static FspPhypSimpleCmds mInst;
    private static final String ERROR_TYPE = "ERROR_TYPE";
    private static final String ERROR_DATA = "ERROR_DATA";
    private static final String GET_NUMBER_OF_LPAR_SLOTS = "GET_NUMBER_OF_LPAR_SLOTS";
    private static final String NUM_LPAR_SLOTS = "NUM_LPAR_SLOTS";
    private static final String GET_SERVICE_LPAR_ID = "GET_SERVICE_LPAR_ID";
    private static final String LPAR_ID = "LPAR_ID";
    private static final String GET_LPAR_SLOT_DEFINITION_STATE = "GET_LPAR_SLOT_DEFINITION_STATE";
    private static final String DEFINITION_STATE = "DEFINITION_STATE";
    private static final String GET_LPAR_NAME = "GET_LPAR_NAME";
    private static final String LPAR_NAME = "LPAR_NAME";
    private static final String GET_HYPERVISOR_CAPABILITIES = "GET_HYPERVISOR_CAPABILITIES";
    private static final String CAPABILITIES = "CAPABILITIES";
    public static final int FSP_PHYP_LPAR_CAPABLE = 32768;
    public static final int FSP_PHYP_OS400_CAPABLE = 16384;
    public static final int FSP_PHYP_COD_CAPABLE = 8192;
    private static final String SET_HYPERVISOR_POWER_OFF_POLICY = "SET_HYPERVISOR_POWER_OFF_POLICY";
    private static final String SET_HYPERVISOR_GLOBAL_ATTRIBUTES = "SET_HYPERVISOR_GLOBAL_ATTRIBUTES";
    private static final String SET_SERVICE_LPAR_ID = "SET_SERVICE_LPAR_ID";
    private static final String GET_ALL_LPAR_SLOT_DEFINITION_STATES = "GET_ALL_LPAR_SLOT_DEFINITION_STATES";
    private static final String SLOT_DEF_LIST = "SLOT_DEF_LIST";
    public static final int LPAR_UNDEFINED = 0;
    public static final int RPA_LPAR_NOT_BOOTABLE = 1;
    public static final int RPA_LPAR_VALID = 2;
    public static final int MM_LPAR_NOT_BOOTABLE = 65;
    public static final int MM_LPAR_VALID = 66;
    public static final int OS400_LPAR_NOT_BOOTABLE = 129;
    public static final int OS400_LPAR_VALID = 130;
    private static final String GET_HYPERVISOR_GLOBAL_ATTRIBUTES = "GET_HYPERVISOR_GLOBAL_ATTRIBUTES";
    private static final String LID_UPDATE = "LID_UPDATE";
    private static final String SET_LPAR_SLOT_DEFINITION_STATE = "SET_LPAR_SLOT_DEFINITION_STATE";
    private static final String SET_LPAR_NAME = "SET_LPAR_NAME";
    private static final String SET_LPAR_HOSTING_PARTITION_ID = "SET_LPAR_HOSTING_PARTITION_ID";
    private static final String SET_LPAR_CLUSTER_GROUP_ID = "SET_LPAR_CLUSTER_GROUP_ID";
    private static final String START_LPAR_BATCH_MODE = "START_LPAR_BATCH_MODE";
    private static final String SIZE = "SIZE";
    private static final String COMMIT_LPAR_BATCH = "COMMIT_LPAR_BATCH";
    private static final String VARY_ON_OFF_MEMORY = "VARY_ON_OFF_MEMORY";
    private static final String VARY_ON_OFF_PROCESSING = "VARY_ON_OFF_PROCESSING";
    private static final String SET_PENDING_LPAR_SHARED_PROCESSING = "SET_PENDING_LPAR_SHARED_PROCESSING";
    private static final String SET_PENDING_LPAR_DED_PROCESSING = "SET_PENDING_LPAR_DED_PROCESSING";
    private static final String SET_PENDING_LPAR_PROCESSING = "SET_PENDING_LPAR_PROCESSING";
    private static final String SET_PENDING_LPAR_PROCESSING_MODE = "SET_PENDING_LPAR_PROCESSING_MODE";
    private static final String GET_RUNTIME_INTERACTIVE_PERFORMANCE = "GET_RUNTIME_INTERACTIVE_PERFORMANCE";
    private static final String INTERACTIVE = "INTERACTIVE";
    private static final String SET_PENDING_LPAR_INTERACTIVE_PERFORMANCE = "SET_PENDING_LPAR_INTERACTIVE_PERFORMANCE";
    private static final String SET_PENDING_LPAR_MEMORY = "SET_PENDING_LPAR_MEMORY";
    private static final String MM_SET_PEND_LPAR_MEM = "MM_SET_PEND_LPAR_MEM";
    private static final String LPAR_ASYNC_ACKNOWLEDGE = "LPAR_ASYNC_ACKNOWLEDGE";
    private static final String SET_LPAR_SHARED_POOL_UTIL_AUTH = "SET_LPAR_SHARED_POOL_UTIL_AUTH";
    private static final String SET_PEND_SLOT_LOCK_OWNER = "SET_PEND_SLOT_LOCK_OWNER";
    private static final String MANAGE_ONOFF_PROCESSORS = "MANAGE_ONOFF_PROCESSORS";
    private static final String MANAGE_ONOFF_MEMORY = "MANAGE_ONOFF_MEMORY";
    private static final String MANAGE_METERED_PROCESSORS = "MANAGE_METERED_PROCESSORS";
    private static final String DISABLE_TRIAL_RESOURCES = "DISABLE_TRIAL_RESOURCES";
    private static final String GET_COD_STATE = "GET_COD_STATE";
    private static final String COD_STATE = "COD_STATE";
    private static final String GET_COD_CTA_VALUE = "GET_COD_CTA_VALUE";
    private static final String CTA_VALUE = "CTA_VALUE";
    private static final String SET_COD_CTA_VALUE = "SET_COD_CTA_VALUE";
    private static final String SET_COD_RECOVERY_COMPLETE = "SET_COD_RECOVERY_COMPLETE";
    private static final String GET_COD_CAPABILITIES = "GET_COD_CAPABILITIES";
    private static final String COD_CAPABILITIES = "COD_CAPABILITIES";
    private static final String GET_FOD_CAPABILITIES = "GET_FOD_CAPABILITIES";
    private static final String FOD_CAPABILITIES = "FOD_CAPABILITIES";
    private static final String COD_ASYNC_ACKNOWLEDGE = "COD_ASYNC_ACKNOWLEDGE";
    private static final String HYP_PIPE_RESP_ACKNOWLEDGE = "HYP_PIPE_RESP_ACKNOWLEDGE";
    private static final String CLEAR_NON_REPORTING_BUS = "CLEAR_NON_REPORTING_BUS";
    private static final String GET_OS400_CAPACITY = "GET_OS400_CAPACITY";
    private static final String MAX_OS400_PROCUNITS = "MAX_OS400_PROCUNITS";

    static FspPhypSimpleCmds getInstance() {
        if (mInst == null) {
            mInst = new FspPhypSimpleCmds();
        }
        return mInst;
    }

    UnsignedInt16 getNumberOfLparSlotsCmd(FSPCmdMgr fSPCmdMgr) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(GET_NUMBER_OF_LPAR_SLOTS, null);
        return (UnsignedInt16)hashtable.get(NUM_LPAR_SLOTS);
    }

    UnsignedInt16 getServiceLparIdCmd(FSPCmdMgr fSPCmdMgr) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(GET_SERVICE_LPAR_ID, null);
        return (UnsignedInt16)hashtable.get(LPAR_ID);
    }

    UnsignedInt8 getLparSlotDefinitionStateCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(GET_LPAR_SLOT_DEFINITION_STATE, new String[]{unsignedInt16.toString()});
        return (UnsignedInt8)hashtable.get(DEFINITION_STATE);
    }

    String getLparUserDefNameCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(GET_LPAR_NAME, new String[]{unsignedInt16.toString()});
        return (String)hashtable.get(LPAR_NAME);
    }

    BitSet getHypervisorCapabilitiesCmd(FSPCmdMgr fSPCmdMgr) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(GET_HYPERVISOR_CAPABILITIES, null);
        byte[] byArray = (byte[])hashtable.get(CAPABILITIES);
        return ByteUtilities.byteArrayToBitSet(byArray);
    }

    void setHypervisorPowerPolicyCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt8 unsignedInt8) throws PIHscServerException, PIHscCmdMgrException {
        fSPCmdMgr.doPhypCommand(SET_HYPERVISOR_POWER_OFF_POLICY, new String[]{unsignedInt8.toString()});
    }

    void setHypervisorGlobalAttributesCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt8 unsignedInt8) throws PIHscServerException, PIHscCmdMgrException {
        fSPCmdMgr.doPhypCommand(SET_HYPERVISOR_GLOBAL_ATTRIBUTES, new String[]{unsignedInt8.toString()});
    }

    void setServiceLparIdCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16) throws PIHscServerException, PIHscCmdMgrException {
        fSPCmdMgr.doPhypCommand(SET_SERVICE_LPAR_ID, new String[]{unsignedInt16.toString()});
    }

    UnsignedInt8[] getAllLparSlotDefinitionStatesCmd(FSPCmdMgr fSPCmdMgr) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(GET_ALL_LPAR_SLOT_DEFINITION_STATES, null);
        Object[] objectArray = (Object[])hashtable.get(SLOT_DEF_LIST);
        UnsignedInt8[] unsignedInt8Array = new UnsignedInt8[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Hashtable hashtable2 = (Hashtable)objectArray[i];
            unsignedInt8Array[i] = (UnsignedInt8)hashtable2.get(DEFINITION_STATE);
        }
        return unsignedInt8Array;
    }

    Map getDefinedSlotStates(FSPCmdMgr fSPCmdMgr) throws PIHscServerException, PIHscCmdMgrException {
        HashMap<UnsignedInt16, UnsignedInt8> hashMap = new HashMap<UnsignedInt16, UnsignedInt8>();
        UnsignedInt8[] unsignedInt8Array = this.getAllLparSlotDefinitionStatesCmd(fSPCmdMgr);
        for (int i = 0; i < unsignedInt8Array.length; ++i) {
            if (unsignedInt8Array[i].intValue() == 0) continue;
            hashMap.put(new UnsignedInt16(i + 1), unsignedInt8Array[i]);
        }
        return hashMap;
    }

    UnsignedInt8 getHypervisorGlobalAttributesCmd(FSPCmdMgr fSPCmdMgr) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(GET_HYPERVISOR_GLOBAL_ATTRIBUTES, null);
        return (UnsignedInt8)hashtable.get(LID_UPDATE);
    }

    void setLparSlotDefinitionStateCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16, UnsignedInt8 unsignedInt8) throws PIHscServerException, PIHscCmdMgrException {
        fSPCmdMgr.doPhypCommand(SET_LPAR_SLOT_DEFINITION_STATE, new String[]{unsignedInt16.toString(), unsignedInt8.toString()});
    }

    void setLparNameCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16, String string) throws PIHscServerException, PIHscCmdMgrException {
        int n = string.length() % 4;
        n = n == 0 ? (n += 4) : 4 - n;
        for (int i = 0; i < n; ++i) {
            string = string + "\u0000";
        }
        fSPCmdMgr.doPhypCommand(SET_LPAR_NAME, new String[]{unsignedInt16.toString(), new Integer(string.length()).toString(), ByteUtilities.toHexString(string.getBytes())});
    }

    void setLparHostingPartitionIdsCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16, UnsignedInt16[] unsignedInt16Array) throws PIHscServerException, PIHscCmdMgrException {
        String string = ByteUtilities.toHexString(unsignedInt16Array);
        fSPCmdMgr.doPhypCommand(SET_LPAR_HOSTING_PARTITION_ID, new String[]{unsignedInt16.toString(), "" + unsignedInt16Array.length, string});
    }

    void setLparClusterIdCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16, UnsignedInt16 unsignedInt162) throws PIHscServerException, PIHscCmdMgrException {
        fSPCmdMgr.doPhypCommand(SET_LPAR_CLUSTER_GROUP_ID, new String[]{unsignedInt16.toString(), unsignedInt162.toString()});
    }

    UnsignedInt16 startLparBatchModeCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(START_LPAR_BATCH_MODE, new String[]{unsignedInt16.toString()});
        int n = (Integer)hashtable.get(ERROR_TYPE);
        if (n == 33006) {
            CmdExtendedErrorList cmdExtendedErrorList = (CmdExtendedErrorList)hashtable.get(ERROR_DATA);
            System.out.println("startLparBatchMode() failed, extended errors:\n" + cmdExtendedErrorList);
        } else if (n != 0) {
            System.out.println("startLparBatchMode() failed, error code " + n);
        }
        return (UnsignedInt16)hashtable.get(SIZE);
    }

    void commitLparBatchCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt8 unsignedInt8) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(COMMIT_LPAR_BATCH, new String[]{unsignedInt8.toString()});
        int n = (Integer)hashtable.get(ERROR_TYPE);
        if (n == 33006) {
            CmdExtendedErrorList cmdExtendedErrorList = (CmdExtendedErrorList)hashtable.get(ERROR_DATA);
            System.out.println("commitLparBatch() failed, extended errors:\n" + cmdExtendedErrorList);
        } else if (n != 0) {
            System.out.println("commitLparBatch() failed, error code " + n);
        }
    }

    void varyOnOffMemoryCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16, UnsignedInt16 unsignedInt162, int n) throws PIHscServerException, PIHscCmdMgrException {
        System.out.println("in LparLPClient.varyOnOffMemory() -> lparID = " + unsignedInt16 + " , memRegion = " + n);
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(VARY_ON_OFF_MEMORY, new String[]{unsignedInt16.toString(), unsignedInt162.toString(), Integer.toString(n)});
        int n2 = (Integer)hashtable.get(ERROR_TYPE);
        if (n2 == 33006) {
            CmdExtendedErrorList cmdExtendedErrorList = (CmdExtendedErrorList)hashtable.get(ERROR_DATA);
            System.out.println("varyOnOffMemory() failed, extended errors:\n" + cmdExtendedErrorList);
        } else if (n2 != 0) {
            System.out.println("varyOnOffMemory() failed, error code " + n2);
        }
    }

    void varyOnOffProcessingCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16, UnsignedInt16 unsignedInt162, UnsignedInt16 unsignedInt163, UnsignedInt16 unsignedInt164, UnsignedInt32 unsignedInt32, UnsignedInt16 unsignedInt165) throws PIHscServerException, PIHscCmdMgrException {
        int n = unsignedInt162.intValue() * 60000;
        String[] stringArray = new String[]{unsignedInt16.toString(), String.valueOf(unsignedInt162.intValue() * 60), unsignedInt163.toString(), unsignedInt164.toString(), unsignedInt32.toString(), unsignedInt165.toString()};
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(VARY_ON_OFF_PROCESSING, stringArray, n, null, null, null, null, null);
        int n2 = (Integer)hashtable.get(ERROR_TYPE);
        if (n2 == 33006) {
            CmdExtendedErrorList cmdExtendedErrorList = (CmdExtendedErrorList)hashtable.get(ERROR_DATA);
            System.out.println("varyOnOffProcessing() failed, extended errors:\n" + cmdExtendedErrorList);
        } else if (n2 != 0) {
            System.out.println("varyOnOffProcessing() failed, error code " + n2);
        }
    }

    void setLparPendingDedicatedProcessorsCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16, UnsignedInt16 unsignedInt162, UnsignedInt16 unsignedInt163, UnsignedInt16 unsignedInt164) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        hashtable = fSPCmdMgr.doPhypCommand(SET_PENDING_LPAR_DED_PROCESSING, new String[]{unsignedInt16.toString(), "255", "255", unsignedInt162.toString(), unsignedInt163.toString(), unsignedInt164.toString()});
    }

    void setLparPendingSharedProcessorsCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16, UnsignedInt8 unsignedInt8, UnsignedInt16 unsignedInt162, UnsignedInt16 unsignedInt163, UnsignedInt16 unsignedInt164, UnsignedInt32 unsignedInt32, UnsignedInt32 unsignedInt322, UnsignedInt32 unsignedInt323, UnsignedInt8 unsignedInt82) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        String string = "0";
        String string2 = "0";
        String string3 = "0";
        String string4 = "0";
        if (null != unsignedInt32) {
            string = unsignedInt32.toString();
        }
        if (null != unsignedInt322) {
            string2 = unsignedInt322.toString();
        }
        if (null != unsignedInt323) {
            string3 = unsignedInt323.toString();
        }
        if (null != unsignedInt82) {
            string4 = unsignedInt82.toString();
        }
        hashtable = fSPCmdMgr.doPhypCommand(SET_PENDING_LPAR_SHARED_PROCESSING, new String[]{unsignedInt16.toString(), unsignedInt8.toString(), "255", unsignedInt162.toString(), unsignedInt163.toString(), unsignedInt164.toString(), unsignedInt32.toString(), unsignedInt322.toString(), unsignedInt323.toString(), string4});
    }

    void setLparPendingProcessoringModeCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16, UnsignedInt8 unsignedInt8, UnsignedInt8 unsignedInt82) throws PIHscServerException, PIHscCmdMgrException {
        fSPCmdMgr.doPhypCommand(SET_PENDING_LPAR_PROCESSING_MODE, new String[]{unsignedInt16.toString(), unsignedInt8.toString(), unsignedInt82.toString()});
    }

    UnsignedInt16 getLparRuntimePerformanceCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(GET_RUNTIME_INTERACTIVE_PERFORMANCE, new String[]{unsignedInt16.toString()});
        return (UnsignedInt16)hashtable.get(INTERACTIVE);
    }

    void setLparPendingPerformanceCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16, UnsignedInt16 unsignedInt162, UnsignedInt16 unsignedInt163, UnsignedInt16 unsignedInt164) throws PIHscServerException, PIHscCmdMgrException {
        String string = "0";
        String string2 = "0";
        String string3 = "0";
        if (unsignedInt162 != null) {
            string = unsignedInt162.toString();
        }
        if (unsignedInt163 != null) {
            string2 = unsignedInt163.toString();
        }
        if (unsignedInt164 != null) {
            string3 = unsignedInt164.toString();
        }
        fSPCmdMgr.doPhypCommand(SET_PENDING_LPAR_INTERACTIVE_PERFORMANCE, new String[]{unsignedInt16.toString(), string, string2, string3});
    }

    void setLparPendingMemoryCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16, UnsignedInt8 unsignedInt8, UnsignedInt32 unsignedInt32, UnsignedInt32 unsignedInt322, UnsignedInt32 unsignedInt323) throws PIHscServerException, PIHscCmdMgrException {
        fSPCmdMgr.doPhypCommand(SET_PENDING_LPAR_MEMORY, new String[]{unsignedInt16.toString(), unsignedInt8.toString(), unsignedInt32.toString(), unsignedInt322.toString(), unsignedInt323.toString()});
    }

    void setMMLparPendingMemoryCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16, UnsignedInt32 unsignedInt32, UnsignedInt32 unsignedInt322, UnsignedInt32 unsignedInt323, UnsignedInt32 unsignedInt324, UnsignedInt32 unsignedInt325, UnsignedInt32 unsignedInt326) throws PIHscServerException, PIHscCmdMgrException {
        fSPCmdMgr.doPhypCommand(MM_SET_PEND_LPAR_MEM, new String[]{unsignedInt16.toString(), unsignedInt32.toString(), unsignedInt322.toString(), unsignedInt323.toString(), unsignedInt324.toString(), unsignedInt325.toString(), unsignedInt326.toString()});
    }

    void lparAsyncAcknowledgeCmd(FSPCmdMgr fSPCmdMgr, byte[] byArray) throws PIHscServerException {
        fSPCmdMgr.doPhypCommand(LPAR_ASYNC_ACKNOWLEDGE, null, 0, byArray, null, null, null, null);
    }

    void setLparSharedPoolUtilizationAuthorityCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16, UnsignedInt8 unsignedInt8) throws PIHscServerException {
        fSPCmdMgr.doPhypCommand(SET_LPAR_SHARED_POOL_UTIL_AUTH, new String[]{unsignedInt16.toString(), unsignedInt8.toString()});
    }

    void setPendingSlotLockOwnerCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt32 unsignedInt32, UnsignedInt16 unsignedInt16) throws PIHscServerException {
        fSPCmdMgr.doPhypCommand(SET_PEND_SLOT_LOCK_OWNER, new String[]{unsignedInt32.toString(), unsignedInt16.toString()}, unsignedInt32);
    }

    void manageOnoffProcessorsCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt32 unsignedInt32, UnsignedInt32 unsignedInt322) throws PIHscCmdMgrException {
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(MANAGE_ONOFF_PROCESSORS, new String[]{unsignedInt32.toString(), unsignedInt322.toString()});
    }

    void manageOnoffMemoryCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt32 unsignedInt32, UnsignedInt32 unsignedInt322) throws PIHscCmdMgrException {
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(MANAGE_ONOFF_MEMORY, new String[]{unsignedInt32.toString(), unsignedInt322.toString()});
    }

    void manageMeteredProcessorsCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt32 unsignedInt32) throws PIHscCmdMgrException {
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(MANAGE_METERED_PROCESSORS, new String[]{unsignedInt32.toString()});
    }

    void disableTrialResourcesCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt8 unsignedInt8) throws PIHscCmdMgrException {
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(DISABLE_TRIAL_RESOURCES, new String[]{unsignedInt8.toString()});
    }

    UnsignedInt8 getCodStateCmd(FSPCmdMgr fSPCmdMgr) throws PIHscCmdMgrException {
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(GET_COD_STATE, null);
        return (UnsignedInt8)hashtable.get(COD_STATE);
    }

    UnsignedInt8 getCodCtaValueCmd(FSPCmdMgr fSPCmdMgr) throws PIHscCmdMgrException {
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(GET_COD_CTA_VALUE, null);
        return (UnsignedInt8)hashtable.get(CTA_VALUE);
    }

    void setCodCtaValueCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt8 unsignedInt8) throws PIHscCmdMgrException {
        fSPCmdMgr.doPhypCommand(SET_COD_CTA_VALUE, new String[]{unsignedInt8.toString()});
    }

    void setCodRecoveryCompleteCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt8 unsignedInt8) throws PIHscCmdMgrException {
        fSPCmdMgr.doPhypCommand(SET_COD_RECOVERY_COMPLETE, new String[]{unsignedInt8.toString()});
    }

    BitSet getCodCapabilitiesCmd(FSPCmdMgr fSPCmdMgr) throws PIHscCmdMgrException {
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(GET_COD_CAPABILITIES, null);
        byte[] byArray = (byte[])hashtable.get(COD_CAPABILITIES);
        return ByteUtilities.byteArrayToBitSet(byArray);
    }

    BitSet getFoDCapabilitiesCmd(FSPCmdMgr fSPCmdMgr) throws PIHscCmdMgrException {
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(GET_FOD_CAPABILITIES, null);
        byte[] byArray = (byte[])hashtable.get(FOD_CAPABILITIES);
        return ByteUtilities.byteArrayToBitSet(byArray);
    }

    void codAsyncAcknowledgeCmd(FSPCmdMgr fSPCmdMgr, byte[] byArray) throws PIHscCmdMgrException {
        fSPCmdMgr.doPhypCommand(COD_ASYNC_ACKNOWLEDGE, null, 0, byArray, null, null, null, null);
    }

    void acknowledgeHypPipeRespCmd(FSPCmdMgr fSPCmdMgr, byte[] byArray, int n) throws PIHscCmdMgrException {
        fSPCmdMgr.doPhypCommand(HYP_PIPE_RESP_ACKNOWLEDGE, new String[]{new Integer(n).toString()}, 0, byArray, null, null, null, null);
    }

    void clearStaleIoBusCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16) throws PIHscCmdMgrException {
        fSPCmdMgr.doPhypCommand(CLEAR_NON_REPORTING_BUS, new String[]{unsignedInt16.toString()});
    }

    UnsignedInt16 getOS400CapacityCmd(FSPCmdMgr fSPCmdMgr) throws PIHscCmdMgrException {
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(GET_OS400_CAPACITY, null);
        return (UnsignedInt16)hashtable.get(MAX_OS400_PROCUNITS);
    }
}

